precision highp float;

//declare uniforms
uniform sampler2D u_texture;

//"in" attributes from our vertex shader
varying vec4 v_color;
varying vec2 v_texCoords;

void main() {
	vec4 pixelColor = texture2D(u_texture, v_texCoords);

	// Discard black pixels (with threshold)
	if (pixelColor.r <= 0.11 && pixelColor.g <= 0.11 && pixelColor.b <= 0.11)
	{
		discard;
	}

	gl_FragColor = v_color * pixelColor;
}